<?
/*
$Id: admin_filemgr.inc.php,v 1.1 2002/06/02 20:56:28 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/
if(strstr($PHP_SELF, basename(__FILE__)))
{
	@include("../include/functions.inc.php");
	redirect("../index.php", 0);
	exit;
}

loadtemplates('filemanager_cp, filemanager_header, filemanager_footer');

// get template creates control panel
eval("\$filemanager_cp = \"".template("filemanager_cp")."\";");
echo $filemanager_cp;

/************************** FUNCTIONS ****************************************/
// calculate the size of files in $dir

function dirsize($dir)
{
	$fm = opendir($dir);
	$size = 0;
	while(($file = readdir($fm)) !== false)
	{
		if($file != "." and $file != "..")
		{
			$path = $dir . "/" . $file;
			if(is_dir($path))
			{
				$size += @dirsize("$path/");
			}
			elseif(is_file($path))
			{
				$size += @filesize($path);
			}
		}
	}
	closedir($fm);
	return $size;
}
/****************************** END OF FUNCTIONS *****************************************/

/************************** USER DEFINED VARIABLES ***************************************

AUTHENTICATION : FileManager is set up so only the Admin user can see the Manager.

MAX FILE SIZE : The program sets a limit for the maximum allowed file size. The default is 1MB. You can change this by setting the $MaxFileSize configuration variable in the program.

MAX HDD SPACE : The program sets a limit for the maximum total size of all files in the directory. The default is 100MB. You can change this by setting the $HDDSpace configuration variable in the program.

HIDDEN FILES : The program allows for hidden files. You can designate a file as a hidden file by adding the file name to the $HiddenFiles array in the program. e.g. $HiddenFiles = array("file1.ext","file2.jpg","file3.jpg");

EDITING FILES : The program by default allows you to edit files with the extensions .htm .html .txt If you want to edit files with other extensions you need to change the $EditExtensions configuration variable in the top of the program. Just add or remove extensions from the $EditExtensions array. You can also turn file editing off altogether by setting $EditOn = 0

ADD AND REMOVE DIRECTORIES (FOLDERS) : The program allows you to add and delete directories. This functionality can be turned off by setting $MakeDirOn = 0 in the configuration variables at the top of the program

SECURITY : The authentication system is not bullet proof, it could be broken into if someone was determined enough. Do not use this program in directories that contain important files such as credit card numbers.

*/

// set these configuration variables
$MaxFileSize = "1048576"; // max file size in bytes that you will ALLOW
$HDDSpace = "104857600"; // max total size of all files in directory
$HiddenFiles = array(".htaccess", "fileicon.gif", "folder.gif", "arrowicon.gif", "config.php"); // add any file names to this array which should remain invisible
$EditOn = 1; // make this = 0 if you dont want the to use the edit document function at all
$EditExtensions = array("htm", "html", "txt", "php", "asp", "js"); // add the extensions of file types that you would like to be able to edit... NOTE Word.doc does not work (yet :)
$MakeDirOn = 1; // make this = 0 if you dont want to be able to make directories
$MakeDirPerm = 1; // make this = 0 if you dont want to be able to change permissions of dir (dosen't work)
$imgfiledir = "$common";
/********************************************************************/

$ThisFileName = basename(__FILE__); // get the file name
$path = dirname(str_replace($ThisFileName, "", __FILE__)) . "/";   // get the directory path

if($back)
{
	$pathext = substr($pathext, 0, -1);
	$slashpos = strrpos($pathext, "/");
	if($slashpos == 0)
	{
		$pathext = "";
	}
	else
	{
		$pathext = substr($pathext, 0, ($slashpos+1));
	}
}

if($edit && !in_array($edit, $HiddenFiles))
{
	// Security Fix
	$edit = basename($edit);
	$pathext = str_replace("../", "", $pathext);

	if(file_exists($path . $pathext . $edit))
	{
		// if an edit link was clicked
		$fp = @fopen($path . $pathext . $edit, "r");
		$old = @fread($fp, filesize($path . $pathext . $edit));
		$old = trim($old);
		@fclose($fp);
		$trans = get_html_translation_table(HTML_ENTITIES);
		$old = strtr($old, $trans);
		$old = str_replace("\\'", "'", $old);

		// get template this is template for edit function if clicked
		eval("\$filemanager_edit = \"".template("filemanager_edit")."\";");
		echo $filemanager_edit;
	}
	else
	{
		message("$pathext$edit doesn't exist!", "&nbsp;", "&nbsp;");
	}
}
elseif(!$loginfailed)
{
	// if the save button was pressed on the edit screen
	if($save)
	{
		$new = stripslashes($new);
		$new = str_replace("\r", "", $new);
		$trans = get_html_translation_table(HTML_ENTITIES);
		$trans = array_flip($trans);
		$new = strtr($new, $trans);
		$fp = @fopen($path . $pathext . $savefile, "w");
		$new = str_replace("\r", "", $new);
		@fwrite($fp, $new);
		@fclose($fp);
	}

	$HDDTotal = dirsize($path); // get the total size of all files in the directory including any sub directorys
	if ($upload)
	{
		// if the upload button was pressed
		if($HTTP_POST_FILES['uploadedfile']['name'])
		{
			// if a file was actually uploaded : remove any % signs from the file name
			$HTTP_POST_FILES['uploadedfile']['name'] = str_replace("%", "", $HTTP_POST_FILES['uploadedfile']['name']);

			// if the file size is within allowed limits
			if($HTTP_POST_FILES['uploadedfile']['size'] > 0 && $HTTP_POST_FILES['uploadedfile']['size'] < $MaxFileSize)
			{
				// if adding the file will not exceed the maximum allowed total
				if(($HDDTotal + $HTTP_POST_FILES['uploadedfile']['size']) < $HDDSpace)
				{
					// put the file in the directory
					move_uploaded_file($HTTP_POST_FILES['uploadedfile']['tmp_name'], $path . $pathext . $HTTP_POST_FILES['uploadedfile']['name']);
					chmod($path . $pathext . $HTTP_POST_FILES['uploadedfile']['name'], 0644);
				}
				else
				{
					$error_msg = $lang['nofreespace'];
				}
			}
			else
			{
				$MaxKB = $MaxFileSize/1024; // show the max file size in Kb
				$error_msg =  $lang['fmmaxsize'];
			}
		}
		else
		{
			$error_msg =  $lang['fmuploaderror'];
		}
	}
	elseif($delete)
	{
		// if the delete button was pressed : delete the file or directory
		if(is_dir($path . $pathext . $delete))
		{
			$result = @rmdir($path . $pathext . $delete);
			if($result == 0)
			{
				$error_msg = $lang['fmfolderdel'];
			}
		}
		else
		{
			$result = @unlink($path . $pathext . $delete);
			if($result == 0)
			{
				$error_msg = "Error deleting file";
			}
		}
	}
	elseif($mkdir && $MakeDirOn)
	{
		umask(000);
		$result = @mkdir($path.$pathext.$dirname, 0777);
		if($result == 0)
		{
			$error_msg = $lang['fmfolder'];
		}
	}

	$error_msg = "<font face=\"Verdana, Arial, Hevetica\" size=\"2\" color=\"*ff0000\">$error_msg</font><br />\n";

	$HDDTotal = dirsize($path); // get the total size of all files in the directory including any sub directorys
	$freespace = ($HDDSpace - $HDDTotal)/1024; // work out how much free space is left
	$HDDTotal = (int) ($HDDTotal/1024); // convert to Kb instead of bytes and type cast it as an int
	$freespace = (int) $freespace; // type cast as an int
	$HDDSpace = (int) ($HDDSpace/1024); // convert to Kb instead of bytes and type cast it as an int
	$MaxFileSizeKb = (int) ($MaxFileSize/1024); // convert to Kb instead of bytes and type cast it as an int

	// if $MakeDirOn has been set to on show some html for making directories
	if($MakeDirOn)
	{
		$mkdirhtml = "<input type=\"text\" name=\"dirname\" size=\"15\"><input type=\"submit\" name=\"mkdir\" value=\"$lang[textcreatedir]\">";
	}

	// This adds permissions to the dir (doesn't work)
	if($MakeDirPerm)
	{
		$mkdirperm = "<select size=\"1\" name=\"dirperm\"><option value=\"0777\">777</option> <option value=\"0755\" selected>755</option> <option value=\"0655\">655</option></select>";
	}

	// get template creates header
	eval("\$filemanager_header = \"".template("filemanager_header")."\";");
	echo $filemanager_header;

	// if the current directory is a sub directory show a back link to get back to the previous directory
	if($pathext)
	{
		$fileicon = "<img src=\"$imgfiledir/arrowicon.gif\">";
		// get template creates folder icon when folder dir is clicked
		eval("\$filemanager_folder = \"".template("filemanager_folder")."\";");
		echo $filemanager_folder;
	}

	// build the table rows which contain the file information
	$newpath = substr($path . $pathext, 0, -1);   // remove the forward or backwards slash from the path
	$dir = @opendir($newpath); // open the directory
	while($file = readdir($dir))
	{
		// loop once for each name in the directory
		// if the name is not a directory and the name is not the name of this program file
		if($file != "." && $file != ".." && $file != "$ThisFileName")
		{
			$match = 0;
			foreach($HiddenFiles as $name)
			{
				// for each value in the hidden files array
				if($file == $name)
				{
					// check the name is not the same as the hidden file name
					$match = 1;         // set a flag if this name is supposed to be hidden
				}
			}
			if(!$match)
			{
				 // if there were no matches the file should not be hidden
				$filedata = stat($path . $pathext . $file); // get some info about the file

				// find out if the file is one that can be edited
				$editlink = "";
				if($EditOn && !is_dir($path . $pathext . $file))
				{
					// if the edit function is turned on and the file is not a directory
					$dotpos = strrpos($file, ".");
					foreach($EditExtensions as $editext)
					{
						$ext = substr($file, ($dotpos + 1));
						if(strcmp($ext, $editext) == 0)
						{
							$editlink = "<a href='$PHP_SELF?action=$action&edit=$file&pathext=$pathext'>EDIT</a>";
						}
					}
				}

				// create some html for a link to delete files
				$deletelink = "<a href=\"$PHP_SELF?action=$action&delete=$file&pathext=$pathext\">DELETE</a>";

				// if it is a directory change the file name to a directory link
				if(is_dir($path . $pathext . $file))
				{
					$filename = "<a href=\"$PHP_SELF?action=$action&pathext=$pathext$file/\">$file</a>";
					$fileicon = "<img src=\"$imgfiledir/folder.gif\">";
					if(!$MakeDirOn)
					{
						$deletelink = "";
					}
				}
				else
				{
					$filename = "<a href=\"$pathext$file\" target=\"_blank\">$file</a>";
					$fileicon = "<img src=\"$imgfiledir/fileicon.gif\">";
				}
				// get template creates folder icon
				eval("\$filemanager_file = \"".template("filemanager_file")."\";");
				echo $filemanager_file;
			}
		}
	}
	closedir($dir); // now that all the rows have been built close the directory
}

eval("\$filemanager_footer = \"".template("filemanager_footer")."\";");
echo $filemanager_footer;

?>
