<?
/*
$Id: functions.inc.php,v 1.33 2002/06/14 14:37:58 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/

function template($name)
{
	global $tempcache, $table, $db, $devel;

	if (isset($tempcache[$name]))
	{
		$template = $tempcache[$name];
	}
	else
	{
		$query = $db->query("SELECT * FROM $table[templates] WHERE name='$name'");
		$gettemplate = $db->fetch_array($query);
		$template = $gettemplate['template'];
		$tempcache[$name] = $template;
	}
	$template = str_replace("\\'", "'", $template);
	if($devel['debug'] != "no")
	{
		return "<!--Begin Template: $name -->\n" . trim($template) . "\n<!-- End Template: $name -->\n";
	}
	else
	{
		return trim("$template");
	}
}

function loadtemplates($names)
{
	global $db, $tempcache, $table;
	$comma = "";
	$sql = "";
	$namesarray = exploder($names, ",", "'");
	$sql = implode(", ", $namesarray);
	$query = $db->query("SELECT * FROM $table[templates] WHERE name IN ($sql)");
	while($template = $db->fetch_array($query))
	{
		$tempcache[$template['name']] = $template['template'];
	}
}

function readFileAsINI($filename)
{
// Function taken from a phpBB hack with permission
	if(file_exists($filename))
	{
		$fc = file($filename);
		while (list($linenum, $line) = each($fc))
		{
			$temp = explode("=", $line);
			$key = trim($temp[0]);   
			$val = trim($temp[1]);   
			$thefile[$key] = $val; 
		}
		return $thefile;
	}
	else
	{
		return false;
	}
}

function exploder($string, $sep=",", $quote="")
{
	$array = array();
	if($string != "")
	{
		$array = explode($sep, $string);
		foreach ($array as $key => $value)
		{
			$key = trim($key);
			$array[$key] = "$quote".trim($value)."$quote";
		}
	}
	return $array;
}

function GetOut($Array, $item, $case=TRUE)
{
	if($case)
	{
		foreach($Array as $element)
		{
			if($element != $item)
			{
				$ArrayOut[] = $element;
			}
		}
	}
	else
	{
		$itemtmp = strtolower($item);
		foreach($Array as $element)
		{
			if(strtolower($element) != $itemtmp)
			{
				$ArrayOut[] = $element;
			}
		}
	}
	return $ArrayOut;
}

function postify($message, $smileyoff, $bbcodeoff, $allowsmilies = "yes", $allowhtml = "yes", $allowbbcode = "yes", $allowimgcode = "yes", $highlight = "")
{
	global $imgdir, $bordercolor, $table, $db, $smdir, $smiliecache, $censorcache, $smiliesnum, $wordsnum;

	if($allowhtml != "yes" || $allowhtml == "no")
	{
		$message = htmlspecialchars($message, ENT_QUOTES);
	}
	$message = nl2br($message);

	if($smileyoff != "yes" && $allowsmilies == "yes")
	{
		if($smiliesnum > 0)
		{
			reset($smiliecache);
			while(list($code, $url) = each($smiliecache))
			{
				$message = str_replace("$code", "<img src=\"$smdir/$url\" align=\"absmiddle\" border=0>", $message);
			}
		}
	}

	if($bbcodeoff != "yes" && $allowbbcode == "yes")
	{
		if(!eregi("\\[code\\]", $message))
		{
			$message = wordwrap($message, 150, "\n", 1);
		}

		if($highlight != "")
		{
			$message = str_replace("$highlight ", "<font color='red'><b>$highlight</b></font> ", $message);
		}

		$message = bbcode_replace($message);
		$message = str_replace("[fortune]", nl2br(htmlspecialchars(fortune(), ENT_QUOTES)), $message);
		$message = eregi_replace("javascript:", "Jabbascript:", $message);
		$message = str_replace("[*]", "<li>", $message);
		$message = eregi_replace("(^|[>[:space:]\n])([[:alnum:]]+)://([^[:space:]]*)([[:alnum:]#~?/&=])([<[:space:]]|$)","\\1<a href=\"\\2://\\3\\4\" target=\"_blank\">\\2://\\3\\4</a>\\5", $message);
		$message = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<font color=\"\\1\">\\2</font>",$message);
		$message = eregi_replace("\\[size=([^\\[]*)\\]([^\\[]*)\\[/size\\]","<font size=\"\\1\">\\2</font>",$message);
		$message = eregi_replace("\\[font=([^\\[]*)\\]([^\\[]*)\\[/font\\]","<font face=\"\\1\">\\2</font>",$message);
		$message = eregi_replace("\\[align=([^\\[]*)\\]([^\\[]*)\\[/align\\]","<p align=\"\\1\">\\2</p>",$message);
		$patterns = array();
		$replacements = array();
		$patterns[0] = "#\[url\]([a-z]+?://){1}(.*?)\[/url\]#si";
		$replacements[0] = '<a href="\1\2" target="_blank">\1\2</a>';
		$patterns[1] = "#\[url\](.*?)\[/url\]#si";
		$replacements[1] = '<a href="http://\1" target="_blank">\1</a>';
		$patterns[2] = "#\[url=([a-z]+?://){1}(.*?)\](.*?)\[/url\]#si";
		$replacements[2] = '<a href="\1\2" target="_blank">\3</a>';
		$patterns[3] = "#\[url=(.*?)\](.*?)\[/url\]#si";
		$replacements[3] = '<a href="\1" target="_blank">\2</a>';
		$patterns[4] = "#\[email\](.*?)\[/email\]#si";
		$replacements[4] = '<a href="mailto:\1">\1</a>';
		$patterns[5] = "#\[email=(.*?){1}(.*?)\](.*?)\[/email\]#si";
		$replacements[5] = '<a href="mailto:\1\2">\3</a>';
		$message = preg_replace($patterns, $replacements, $message);
	}

	if($allowimgcode == "yes" && $bbcodeoff != "yes")
	{
		$message = eregi_replace("\\[img\\]([^\\[]*)\\[/img\\]", "<img src=\"\\1\" border=0>", $message);
		$message = eregi_replace("\\[img=([^\\[]*)x([^\\[]*)\\]([^\\[]*)\\[/img\\]", "<img width=\"\\1\" height=\"\\2\" src=\"\\3\" border=0>", $message);
	}

	$pre = "([^[:alpha:]]|^)";
	$suf = "([^[:alpha:]]|$)";
	if($wordsnum > 0)
	{
		reset($censorcache);
		while(list($find, $replace) = each($censorcache))
		{
			$message = eregi_replace($pre.$find.$suf, "\\1$replace\\2", $message);
		}
		reset($censorcache);
		while(list($find, $replace) = each($censorcache))
		{
			$message = eregi_replace($pre.$find.$suf, "\\1$replace\\2", $message);
		}
	}
	return $message;
}

function modcheck($status, $username, $fid)
{
	global $db, $table;
	if($status == "Moderator")
	{
		$query = $db->query("SELECT * FROM $table[forums] WHERE moderator LIKE '%$username%'");
		while($mod = $db->fetch_array($query))
		{
			if($mod['fid'] == $fid)
			{
				$modgood = "yes";
			}
		}

		if($modgood == "yes")
		{
			$status1 = "Moderator";
		}

	}
	return $status1;
}

function privfcheck($private, $userlist)
{
	global $status, $o2user, $hideprivate;

	if($private == "2" && $status == "Administrator")
	{
		return true;
	}
	elseif($private == "3" && ($status == "Administrator" || $status == "Moderator" || $status == "Super Moderator"))
	{
		return true;
	}
	elseif($private == "1" && $userlist == "")
	{
		return true;
	}
	elseif($userlist != "")
	{
		$userarray = exploder($userlist);
		if($o2user != "" && in_array($o2user, $userarray) || $status == "Administrator")
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

function forum($forum, $template)
{
	global $oldtopics, $timecode, $dateformat, $lang, $o2user, $status, $lastvisit, $timeoffset, $hideprivate, $newmsg, $altbg1, $altbg2, $imgdir;

	if($forum['lastpost'] != "")
	{
		$lastpost = explode("|", $forum['lastpost']);
		$dalast = $lastpost[0];
		$thelastpid = $lastpost[2];
		if($lastpost[1] != "Anonymous")
		{
			$lastpost[1] = "<a href=\"member.php?action=viewpro&member=".rawurlencode($lastpost[1])."\">$lastpost[1]</a>";
		}
		else
		{
			$lastpost[1] = "$lang[textanonymous]";
		}

		$lastpostdate = gmdate("$dateformat", $lastpost[0] + ($timeoffset * 3600));
		$lastposttime = gmdate("$timecode", $lastpost[0] + ($timeoffset * 3600));
		$lastpost = "$lastpostdate $lang[textat] $lastposttime<br />$lang[textby] $lastpost[1]";
		eval("\$lastpostrow = \"".template("".$template."_lastpost")."\";");
	}
	else
	{
		$lastpostrow = "<font class=\"smalltxt\">$lang[lpoststats]: $lang[textnever]</font>";
	}
	$lastvisit -= $newmsg;

	if($lastvisit < $dalast && !strstr($oldtopics, "|$thelastpid|"))
	{
		$folder = "<img src=\"$imgdir/red_folder.gif\">";
	}
	else
	{
		$folder = "<img src=\"$imgdir/folder.gif\">";
	}

	$forum['description'] = stripslashes($forum['description']);

	if($dalast == "")
	{
		$folder = "<img src=\"$imgdir/folder.gif\">";
	}

	$lastvisit += $newmsg;
	$authorization = privfcheck($forum['private'], $forum['userlist']);
	$comma = "";
	if($authorization || $hideprivate == "no")
	{
		if($forum['moderator'] != "")
		{
			$moderators = exploder($forum['moderator']);
			$forum['moderator'] = "";
			for($num = 0; $num < count($moderators); $num++)
			{
				$forum['moderator'] .= "$comma<a href=\"member.php?action=viewpro&member=$moderators[$num]\">$moderators[$num]</a>";
				$comma = ", ";
			}
			if($forum['type'] == "sub")
			{
				$forum['moderator'] = "<font class=\"smalltxt\">($lang[textmodby] $forum[moderator])</font>";
			}
		}
		else
		{
			$forum['moderator'] = $lang['textnone'];
		}
		eval("\$foruminfo .= \"".template("$template")."\";");
	}

	$dalast = "";
	$fmods = "";
	$authorization = "";
	return $foruminfo;
}

function multi($num, $perpage, $page, $mpurl)
{
	if($num > $perpage)
	{
		$pages = ceil($num / $perpage);

		if($page == $pages)
		{
			$to = $pages;
		}
		elseif($page == $pages-1)
		{
			$to = $page+1;
		}
		elseif($page == $pages-2)
		{
			$to = $page+2;
		}
		else
		{
			$to = $page+3;
		}

		if($page == 1 || $page == 2 || $page == 3)
		{
			$from = 1;
		}
		else
		{
			$from = $page-3;
		}
		$fwd_back .= "<a href=\"$mpurl&page=1\"><<</a>";

		for($i = $from; $i <= $to; $i++)
		{
			if($i != $page)
			{
				$fwd_back .= "&nbsp;&nbsp;<a href=\"$mpurl&page=$i\">$i</a>&nbsp;&nbsp;";
			}
			else
			{
				$fwd_back .= "&nbsp;&nbsp;<u><b>$i</b></u>&nbsp;&nbsp;";
			}
		}

		$fwd_back .= "<a href=\"$mpurl&page=$pages\">>></a>";
		$multipage = $fwd_back;
	}
	return $multipage;
}

function bbcodeinsert()
{
	global $imgdir, $bbinsert, $altbg1, $altbg2, $lang;
	if($bbinsert == "yes")
	{
		eval("\$bbcode = \"".template("functions_bbcodeinsert")."\";");
	}
	return $bbcode;
}

function smilieinsert()
{
	global $imgdir, $smdir, $table, $db, $smileyinsert, $smcols, $smtotal, $lang;

	if($smileyinsert == "yes" && $smtotal != "" && $smcols != "")
	{
		$col_smilies = 0;
		$smilies .= "<tr>";
		$querysmilie = $db->query("SELECT * FROM $table[smilies] WHERE type='smiley' LIMIT 0, $smtotal");
		while($smilie = $db->fetch_array($querysmilie))
		{
			eval("\$smilies .= \"".template("functions_smilieinsert_smilie")."\";");
			$col_smilies += 1;
			if($col_smilies == $smcols)
			{
				$smilies .= "</tr>";
				$col_smilies = 0;
			}
		}
		eval("\$smilieinsert .= \"".template("functions_smilieinsert")."\";");
	}
	return $smilieinsert;
}

function smcwcache()
{
	global $db, $table, $smiliecache, $censorcache, $smiliesnum, $wordsnum;

	$query = $db->query("SELECT count(*) FROM $table[smilies] WHERE type='smiley'");
	$smiliesnum = $db->result($query, 0);
	$query = $db->query("SELECT count(*) FROM $table[words]");
	$wordsnum = $db->result($query, 0);

	if($smiliesnum)
	{
		$query = $db->query("SELECT * FROM $table[smilies] WHERE type='smiley'");
		while($smilie = $db->fetch_array($query))
		{
			$smiliecache[$smilie['code']] = $smilie['url'];
		}
	}
	if($wordsnum)
	{
		$query = $db->query("SELECT * FROM $table[words]");
		while($word = $db->fetch_array($query))
		{
			$censorcache[$word['find']] = $word['replace1'];
		}
	}
}

function redirect($url, $time = "1250", $redir = "no")
{
	$redirjs = "<script> function redirect() { window.location.replace(\"$url\"); } setTimeout(\"redirect();\", $time); </script>";

	if($redir == "no")
	{
		echo $redirjs;
	}
	else
	{
		return $redirjs;
	}
}

function status2private($status)
{
	if($status == "Administrator")
	{
		return 3;
	}
	elseif($status == "Moderator" || $status == "Super Moderator")
	{
		return 2;
	}
	else
	{
		return 1;
	}
}

function o2cookie($name, $value, $expire = 0, $path = "", $domain = "", $secure = 0)
{
	global $cookie;

	$delete = time() - $expire;
	$name = $cookie['prefix'] . $name;
	if($path == "" && $domain == "")
	{
		setcookie($name, $value, $delete, $cookie['path'], $cookie['domain'], $secure);
		setcookie($name, $value, $expire, $cookie['path'], $cookie['domain'], $secure);
	}
	else
	{
		setcookie($name, $value, $delete, $path, $domain, $secure);
		setcookie($name, $value, $expire, $path, $domain, $secure);
	}
}

function getcookie($name)
{
	global $HTTP_COOKIE_VARS, $cookie;
	$fullname = $cookie['prefix'] . $name;
	return $HTTP_COOKIE_VARS[$fullname];
}

function pluglink($admin = "no")
{
	global $plug, $lang;

	$pluglinks = "";

	foreach($plug['url'] as $key => $plugin)
	{
		if(!$plug['url'][$key] || !$plug['name'][$key])
		{
			echo $lang['plugbadconf'];
		}
		else
		{
			if($plug['admin'][$key] == $admin && $admin == "yes")
			{
				$pluglinks .= "$caret<a href=\"" . $plug['url'][$key] . "\">" . $plug['name'][$key] . "</a>";
				$caret = " - ";
			}
			elseif($plug['admin'][$key] == $admin && $admin != "yes")
			{
				$pluglinks .= " | <a href=\"" . $plug['url'][$key] . "\"><font class=\"navtd\">" . $plug['name'][$key] . "</font></a>";
			}
		}
	}

	if($pluglinks)
	{
		if($admin == "yes")
		{
			$pluglinks = "$lang[plugins] $pluglinks";
		}
	}
	return $pluglinks;
}

function plugadmin($installed = "yes", $active = "yes", $admin = "yes")
{
	global $table, $db, $altbg1, $altbg2, $lang;

	$col_plugin = 4;
	$listed_plugin = 0;
	$plug_admin['html'] = "";
	$plug_admin['list'] = array();
	$caret = "";

	loadtemplates("plugin_item");

	$queryp = $db->query("SELECT * FROM $table[plugins] WHERE installed='$installed' AND active='$active' AND admin='$admin' ORDER BY 'porder'");
	while($plugin = $db->fetch_assoc($queryp))
	{
		if(ereg("^lang\[", $plugin['name']))
		{
		    eval("\$title = \"$$plugin[name]\";");
		}
		else
		{
		    $title = $plugin['name'];
		}
		    
		eval("\$plugitem .= \"".template("plugin_item")."\";");
		array_push($plug_admin['list'], $plugin['url']);
		++$listed_plugin;
		if($listed_plugin == $col_plugin)
		{
			$plug_admin['html'] .= "<tr bgcolor=\"$altbg1\">$plugitem</tr>";
			$plugitem = "";
			$listed_plugin = 0;
		}
	}

	if($listed_plugin != 0)
	{
		for($listed_plugin; $listed_plugin < $col_plugin; ++$listed_plugin)
		{
			$plugitem .= "<td class=\"tablerow\" bgcolor=\"$altbg1\">&nbsp;</td>";
		}
		$plug_admin['html'] .= "<tr bgcolor=\"$altbg2\">$plugitem</tr>";
	}
	return $plug_admin;
}

function vartest($variable, $ishtml = false)
{
	global $altbg1, $altbg2;

	if(is_array($variable))
	{
		ksort($variable);
		echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n";
		echo "<tr bgcolor=\"$altbg1\">\n";

		foreach($variable as $key => $element)
		{
			if(is_array($element))
			{
				echo "<td bgcolor=\"$altbg2\" align='center'>\n";
				echo "$key => ";
				vartest($element, $ishtml);
				echo "</td>\n";

			}
			else
			{
				echo "<td bgcolor=\"$altbg1\" align='center'>\n";
				if($ishtml)
				{
					$element = htmlspecialchars($element);
				}
				echo "$key => $element";
				echo "</td>\n";
			}
		}
		echo "</tr>\n";
		echo "</table>\n";
	}
	else
	{
		if($ishtml)
		{
			$variable = htmlspecialchars($variable);
		}
		echo "$variable<br />\n";
	}
}

function bbcode_replace($message)
{
	$bbcodes_array = array(
		array("b", "<b>", "</b>"),
		array("i", "<i>", "</i>"),
		array("u", "<u>", "</u>"),
		array("quote", "<table border=\"0\" align=\"center\" width=\"95%\" cellpadding=\"1\" cellspacing=\"1\"><tr><td class=\"quote\"><span class=\"mediumtxt\">quote: </span>", "</td></tr></table>"),
		array("code", "<table border=\"0\" align=\"center\" width=\"95%\" cellpadding=\"1\" cellspacing=\"1\"><tr><td class=\"quote\"><pre><span class=\"mediumtxt\">code:<br/></span>", "</pre></td></tr></table>"),
		array("list", "<ul type=square>", "</ul>"),
		array("list=1", "<ol type=\"1\">", "</ol>"),
		array("list=a", "<ol type=\"A\">", "</ol>"),
		array("list=A", "<ol type=\"A\">", "</ol>"),
		array("blink", "<blink>", "</blink>"),
		array("marquee", "<marquee>", "</marquee>"),
		array("strike", "<strike>", "</strike>"),
		array("center", "<div align=\"center\">", "</div>"),
	);

	foreach($bbcodes_array as $bbcode)
	{
		$key = $bbcode[0];
		array_shift($bbcode);
		$bbcodes[$key] = $bbcode;
	}

	foreach($bbcodes as $key => $bbcode)
	{
		array_push($bbcode, substr_count($message, "[$key]"), substr_count($message, "[/$key]"));
		$bbcodes[$key] = $bbcode;
	}

	foreach($bbcodes as $key => $bbcode)
	{
		$message = preg_replace(array("#\[$key\]#si", "#\[/$key\]#si"), array($bbcode[0], $bbcode[1]), $message, min($bbcode[2], $bbcode[3]));
	}
	return $message;
}
?>
