<?
/*
$Id: install.inc.php,v 1.25 2002/06/14 14:35:21 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/

function installer($setting, $lang)
{
	@include("./include/config.php");
	@include("./include/class/class.$database.inc.php");

	$db = new dbstuff;
	$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);

	$tables = array('attachments', 'banned', 'box', 'buddys', 'favorites', 'forums', 'ignore', 'log', 'members', 'news',  'plugins', 'posts', 'ranks', 'settings', 'smilies', 'templates', 'themes', 'threads', 'u2u',  'whosonline', 'words');
	foreach($tables as $name)
	{
		$table["$name"] = $tablepre.$name;
	}

	@set_time_limit (1000);

	echo "Creating $table[attachments]...";
	$db->query("DROP TABLE IF EXISTS $table[attachments]");
	$db->query("CREATE TABLE $table[attachments] (
		aid smallint(6) NOT NULL auto_increment,
		tid smallint(6) NOT NULL default '0',
		pid smallint(6) NOT NULL default '0',
		filename varchar(120) NOT NULL default '',
		filetype varchar(120) NOT NULL default '',
		filesize varchar(120) NOT NULL default '',
		attachment longblob NOT NULL,
		downloads smallint(6) NOT NULL default '0',
		PRIMARY KEY (aid),
		KEY tid (tid),
		KEY pid (pid)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[banned]...";
	$db->query("DROP TABLE IF EXISTS $table[banned]");
	$db->query("CREATE TABLE $table[banned] (
		ip1 smallint(3) NOT NULL default '0',
		ip2 smallint(3) NOT NULL default '0',
		ip3 smallint(3) NOT NULL default '0',
		ip4 smallint(3) NOT NULL default '0',
		dateline bigint(30) NOT NULL default '0',
		id smallint(6) NOT NULL default '0',
		PRIMARY KEY (id),
		KEY ip1 (ip1),
		KEY ip2 (ip2),
		KEY ip3 (ip3),
		KEY ip4 (ip4)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[box]...";
	$db->query("DROP TABLE IF EXISTS $table[box]");
	$db->query("CREATE TABLE $table[box] (
		id int(11) NOT NULL auto_increment,
		name text NOT NULL,
		mesg text NOT NULL,
		time int(11) NOT NULL default '0',
		PRIMARY KEY (id)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[buddys]...";
	$db->query("DROP TABLE IF EXISTS $table[buddys]");
	$db->query("CREATE TABLE $table[buddys] (
		username varchar(40) NOT NULL,
		buddyname varchar(40) NOT NULL
	);");
	echo "<b>Done</b><br />";

	echo "Creating $table[favorites]...";
	$db->query("DROP TABLE IF EXISTS $table[favorites]");
	$db->query("CREATE TABLE $table[favorites] (
		tid smallint(6) NOT NULL,
		username varchar(40) NOT NULL,
		type varchar(20) NOT NULL
	);");
	echo "<b>Done</b><br />";

	echo "Creating $table[forums]...";
	$db->query("DROP TABLE IF EXISTS $table[forums]");
	$db->query("CREATE TABLE $table[forums] (
		type varchar(15) NOT NULL default '',
		fid smallint(6) NOT NULL auto_increment,
		name varchar(50) NOT NULL default '',
		status varchar(15) NOT NULL default '',
		lastpost varchar(30) NOT NULL default '',
		moderator varchar(100) NOT NULL default '',
		displayorder smallint(6) NOT NULL default '0',
		private varchar(30) default NULL,
		description text,
		allowhtml char(3) NOT NULL default '',
		allowsmilies char(3) NOT NULL default '',
		allowbbcode char(3) NOT NULL default '',
		userlist text NOT NULL,
		theme varchar(30) NOT NULL default '',
		posts int(100) NOT NULL default '0',
		threads int(100) NOT NULL default '0',
		fup smallint(6) NOT NULL default '0',
		postperm char(3) NOT NULL default '',
		allowimgcode char(3) NOT NULL default '',
		attachstatus char(3) NOT NULL default '',
		pollstatus char(3) NOT NULL default '',
		password varchar(30) NOT NULL default '',
		guestposting char(3) NOT NULL default '',
		PRIMARY KEY (fid),
		KEY fup (fup),
		KEY type (type),
		KEY private (private),
		KEY status (status)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[ignore]...";
	$db->query("DROP TABLE IF EXISTS $table[ignore]");
	$db->query("CREATE TABLE $table[ignore] (
		username varchar(25) NOT NULL,
		ignorename varchar(25) NOT NULL,
		KEY username (username)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[log]...";
	$db->query("DROP TABLE IF EXISTS $table[log]");
	$db->query("CREATE TABLE $table[log] (
		lid bigint(6) NOT NULL auto_increment,
		username varchar(25) NOT NULL,
		ip text NOT NULL,
		time int(11) NOT NULL default '0',
		url text NOT NULL,
		PRIMARY KEY (lid),
		KEY time (time)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[members]...";
	$db->query("DROP TABLE IF EXISTS $table[members]");
	$db->query("CREATE TABLE $table[members] (
		uid smallint(6) NOT NULL auto_increment,
		username varchar(25) NOT NULL default '',
		password varchar(40) NOT NULL default '',
		regdate bigint(30) NOT NULL default '0',
		postnum int(10) NOT NULL default '0',
		email varchar(60) default NULL,
		site varchar(75) default NULL,
		aim varchar(40) default NULL,
		status varchar(35) NOT NULL default '',
		location varchar(50) default NULL,
		bio text,
		sig text,
		showemail varchar(15) NOT NULL default '',
		timeoffset int(5) NOT NULL default '0',
		icq varchar(30) NOT NULL default '',
		avatar varchar(90) default NULL,
		yahoo varchar(40) NOT NULL default '',
		customstatus varchar(250) NOT NULL default '',
		theme varchar(30) NOT NULL default '',
		bday varchar(50) default NULL,
		langfile varchar(40) NOT NULL default '',
		tpp smallint(6) NOT NULL default '0',
		ppp smallint(6) NOT NULL default '0',
		newsletter char(3) NOT NULL default '',
		regip varchar(40) NOT NULL default '',
		timeformat int(5) NOT NULL default '0',
		msn varchar(40) NOT NULL default '',
		dateformat varchar(10) NOT NULL default '',
		ignoreu2u text,
		lastvisit bigint(30) NOT NULL default '0',
		rating blob NOT NULL,
		realname varchar(30) default NULL,
		firstname varchar(30) default NULL,
		emailnotify char(3) NOT NULL default '',
		profileviews int(10) NOT NULL default '0',
		u2upopup char(3) NOT NULL default 'no',
		chatpopup int(5) NOT NULL default '0',
		PRIMARY KEY (uid),
		KEY username (username),
		KEY status (status)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[news]...";
	$db->query("DROP TABLE IF EXISTS $table[news]");
	$db->query("CREATE TABLE $table[news] (
		nid smallint(6) NOT NULL auto_increment,
		author varchar(40) NOT NULL default '',
		dateline bigint(30) NOT NULL default '0',
		subject varchar(120) NOT NULL default '',
		msg text NOT NULL default '',
		PRIMARY KEY (nid)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[plugins]...";
	$db->query("DROP TABLE IF EXISTS $table[plugins]");
	$db->query("CREATE TABLE $table[plugins] (
		plid bigint(20) NOT NULL auto_increment,
		name varchar(25) NOT NULL default '',
		url varchar(75) NOT NULL default '',
		installed char(3) NOT NULL default 'no',
		active char(3) NOT NULL default 'no',
		ptable varchar(25) NOT NULL default '',
		admin char(3) NOT NULL default 'yes',
		porder smallint(6) NOT NULL default '0',
		PRIMARY KEY (plid)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[posts]...";
	$db->query("DROP TABLE IF EXISTS $table[posts]");
	$db->query("CREATE TABLE $table[posts] (
		fid smallint(6) NOT NULL default '0',
		tid smallint(6) NOT NULL default '0',
		pid int(10) NOT NULL auto_increment,
		author varchar(40) NOT NULL default '',
		message text NOT NULL,
		subject varchar(100) NOT NULL default '',
		dateline bigint(30) NOT NULL default '0',
		icon varchar(50) default NULL,
		usesig varchar(15) NOT NULL default '',
		useip varchar(40) NOT NULL default '',
		bbcodeoff varchar(15) NOT NULL default '',
		smileyoff varchar(15) NOT NULL default '',
		PRIMARY KEY (pid),
		KEY fid (fid),
		KEY tid (tid),
		KEY dateline (dateline)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[ranks]...";
	$db->query("DROP TABLE IF EXISTS $table[ranks]");
	$db->query("CREATE TABLE $table[ranks] (
		title varchar(40) NOT NULL default '',
		posts smallint(6) default NULL,
		id smallint(6) NOT NULL auto_increment,
		stars smallint(6) NOT NULL default '0',
		allowavatars char(3) NOT NULL default '',
		avatarrank varchar(90) default NULL,
		PRIMARY KEY (id),
		KEY title (title)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[settings]...";
	$db->query("DROP TABLE IF EXISTS $table[settings]");
	$db->query("CREATE TABLE $table[settings] (
		sid smallint(6) NOT NULL auto_increment,
		status varchar(35) NOT NULL default '',
		users text,
		name text NOT NULL,
		variable varchar(40) NOT NULL default '',
		value text NOT NULL,
		PRIMARY KEY (sid)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[smilies]...";
	$db->query("DROP TABLE IF EXISTS $table[smilies]");
	$db->query("CREATE TABLE $table[smilies] (
		type varchar(15) NOT NULL,
		code varchar(40) NOT NULL,
		url varchar(40) NOT NULL,
		id smallint(6) NOT NULL auto_increment,
		PRIMARY KEY(id)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[templates]...";
	$db->query("DROP TABLE IF EXISTS $table[templates]");
	$db->query("CREATE TABLE $table[templates] (
		id smallint(6) NOT NULL auto_increment,
		name varchar(40) NOT NULL,
		template text NOT NULL,
		PRIMARY KEY(id),
		KEY name (name)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[themes]...";
	$db->query("DROP TABLE IF EXISTS $table[themes]");
	$db->query("CREATE TABLE $table[themes] (
		name varchar(30) NOT NULL default '',
		bgcolor varchar(25) NOT NULL default '',
		altbg1 varchar(15) NOT NULL default '',
		altbg2 varchar(15) NOT NULL default '',
		link varchar(15) NOT NULL default '',
		dummy tinyint(4) NOT NULL default '0',
		bordercolor varchar(15) NOT NULL default '',
		header varchar(15) NOT NULL default '',
		headertext varchar(15) NOT NULL default '',
		top varchar(15) NOT NULL default '',
		catcolor varchar(15) NOT NULL default '',
		tabletext varchar(15) NOT NULL default '',
		text varchar(15) NOT NULL default '',
		borderwidth varchar(15) NOT NULL default '',
		tablewidth varchar(15) NOT NULL default '',
		tablespace varchar(15) NOT NULL default '',
		font varchar(40) NOT NULL default '',
		fontsize varchar(40) NOT NULL default '',
		boardimg varchar(50) default NULL,
		imgdir varchar(120) NOT NULL default '',
		smdir varchar(120) NOT NULL default '',
		cattext varchar(15) NOT NULL default '',
		PRIMARY KEY(name)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[threads]...";
	$db->query("DROP TABLE IF EXISTS $table[threads]");
	$db->query("CREATE TABLE $table[threads] (
		tid int(10) NOT NULL auto_increment,
		fid smallint(6) NOT NULL default '0',
		subject varchar(100) NOT NULL default '',
		icon varchar(75) NOT NULL default '',
		lastpost varchar(30) NOT NULL default '',
		views int(100) NOT NULL default '0',
		replies int(100) NOT NULL default '0',
		author varchar(40) NOT NULL default '',
		closed varchar(15) NOT NULL default '',
		topped smallint(6) NOT NULL default '0',
		pollopts text NOT NULL,
		PRIMARY KEY (tid),
		KEY fid (fid)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[u2u]...";
	$db->query("DROP TABLE IF EXISTS $table[u2u]");
	$db->query("CREATE TABLE $table[u2u] (
		u2uid smallint(6) NOT NULL auto_increment,
		msgto varchar(40) NOT NULL default '',
		msgfrom varchar(40) NOT NULL default '',
		dateline bigint(30) NOT NULL default '0',
		subject varchar(75) NOT NULL default '',
		message text NOT NULL,
		folder varchar(40) NOT NULL default '',
		isnew char(3) NOT NULL default '',
		PRIMARY KEY (u2uid),
		KEY msgto (msgto)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[whosonline]...";
	$db->query("DROP TABLE IF EXISTS $table[whosonline]");
	$db->query("CREATE TABLE $table[whosonline] (
		username varchar(40) NOT NULL default '',
		ip varchar(40) NOT NULL default '',
		time bigint(30) NOT NULL default '0',
		location varchar(150) NOT NULL default '',
		KEY (username)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	echo "Creating $table[words]...";
	$db->query("DROP TABLE IF EXISTS $table[words]");
	$db->query("CREATE TABLE $table[words] (
		find varchar(60) NOT NULL,
		replace1 varchar(60) NOT NULL,
		id smallint(6) NOT NULL auto_increment,
		PRIMARY KEY(id),
		KEY find (find)
	) TYPE=MyISAM;");
	echo "<b>Done</b><br />";

	$db->close();
	$db = new dbstuff;
	$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);

	echo "Inserting Default Data into $table[themes]...";
	$db->query("INSERT INTO $table[themes] VALUES ('$setting[theme]', '#ffffff', '#a2d6ea', '#c9e9ea', '#995533', 0, '#778899', '#9daeea', '#002200', '#ffffff', '#9acef6', '#003300', '#000080', '1', '100%', '2', 'Verdana', '11px', 'Oxygen.jpg', 'images/themes/$setting[theme]', 'images/smilies', '#550055')");
	echo "<b>Done</b><br />";

	echo "Inserting Default Data into $table[forums]...";
	$db->query("INSERT INTO $table[forums] VALUES ('group', 1, 'Catgorie 1', 'yes', '', '', 1, '', '', '', '', '', '', '', 0, 0, 0, '', '', '', '', '', 'no')");
	$db->query("INSERT INTO $table[forums] VALUES ('forum', 2, 'Forum 1', 'yes', '', '', 1, '1', 'Exemple de forum', '', 'yes', 'yes', '', 'Oxygen', 0, 0, 1, '1|1', 'yes', 'yes', 'yes', '', '')");
	$db->query("INSERT INTO $table[forums] VALUES ('sub', 3, 'Sous-Forum 1', 'yes', '', '', 1, '1', 'Exemple de sous-forum', '', 'yes', 'yes', '', 'Oxygen', 0, 0, 2, '1|1', 'yes', 'yes', 'yes', '', '')");
	echo "<b>Done</b><br />";

	echo "Inserting Default Data into $table[plugins]...";
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textsettings]', 'settings', 'yes', 'yes', 'settings', 'yes', 1)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textforums]', 'forum', 'yes', 'yes', 'forums', 'yes', 2)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textmods]', 'mods', 'yes', 'yes', '', 'yes', 3)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textmembers]', 'members', 'yes', 'yes', 'members', 'yes', 4)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textipban]', 'ipban', 'yes', 'yes', 'banned', 'yes', 5)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textupgrade]', 'upgrade', 'yes', 'yes', '', 'yes', 6)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[themes]', 'themes', 'yes', 'yes', 'themes', 'yes', 7)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[smilies]', 'smilies', 'yes', 'yes', 'smilies', 'yes', 8)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textcensors]', 'censor', 'yes', 'yes', 'words', 'yes', 9)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textuserranks]', 'ranks', 'yes', 'yes', 'ranks', 'yes', 10)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textnewsletter]', 'newsletter', 'yes', 'yes', '', 'yes', 11)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textprune]', 'prune', 'yes', 'yes', '', 'yes', 12)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[templates]', 'templates', 'yes', 'yes', 'templates', 'yes', 13)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textattachman]', 'attachments', 'yes', 'yes', 'attachments', 'yes', 14)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[fmheader]', 'filemgr', 'yes', 'yes', '', 'yes', 15)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[logsystem]', 'log', 'yes', 'yes', 'log', 'yes', 16)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[prunemembers]', 'prunemembers', 'yes', 'yes', '', 'yes', 17)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'Plugins', 'plugins', 'yes', 'yes', 'plugins', 'yes', 18)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[plugoptimize]', 'optimize', 'yes', 'yes', '', 'yes', 19)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[fixtitle]', 'fix', 'yes', 'yes', '', 'yes', 20)");
	$db->query("INSERT INTO $table[plugins] VALUES ('', 'Forum Status', 'status', 'yes', 'yes', '', 'yes', 21)");
	echo "<b>Done</b><br />";

	echo "Inserting Default Data into $table[smilies]...";
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':)', 'smile.gif', 1)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':(', 'sad.gif', 2)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':D', 'biggrin.gif', 3)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ';)', 'wink.gif', 4)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':cool:', 'cool.gif', 5)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':mad:', 'mad.gif', 6)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':o', 'shocked.gif', 7)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':P', 'tongue.gif', 8)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'smile.gif', 9)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'sad.gif', 10)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'biggrin.gif', 11)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'wink.gif', 12)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'cool.gif', 13)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'mad.gif', 14)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'shocked.gif', 15)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'thumbup.gif', 16)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'thumbdown.gif', 17)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':grin:', 'bigsmile.gif', 18)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'bigsmile.gif', 19)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-?', 'puzzled.gif', 20)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'puzzled.gif', 21)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', '8)', 'cool2.gif', 22)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'cool2.gif', 23)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':lol:', 'lol.gif', 24)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'lol.gif', 25)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-p', 'roll.gif', 28)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'roll.gif', 29)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-o', 'rolleyes.gif', 30)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'rolleyes.gif', 31)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':ange:', 'saint.gif', 32)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'saint.gif', 33)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':x', 'flaming.gif', 34)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'flaming.gif', 35)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun:', 'gun.gif', 36)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':eek:', 'eek.gif', 38)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun1:', 'gun1.gif', 40)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun2:', 'gun2.gif', 42)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun3:', 'gun3.gif', 44)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun4:', 'gun4.gif', 46)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun5:', 'gun5.gif', 48)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun6:', 'gun6.gif', 50)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'no.gif', 63)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':up:', 'up.gif', 52)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':hot:', 'hot.gif', 54)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':no:', 'no.gif', 62)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':eldiablo:', 'diablotin.gif', 56)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'diablotin.gif', 57)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':sleep:', 'sleep.gif', 58)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'sleep.gif', 59)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':love:', 'love.gif', 60)");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'love.gif', 61)");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':eureka:', 'eureka.gif', 64)");
	echo "<b>Done</b><br />";

	echo "Inserting Default Data into $table[ranks]...";
	$db->query("INSERT INTO $table[ranks] VALUES ('Newbie', '1', '', '1', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Junior Member', '2', '', '2', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Member', '100', '', '3', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Senior Member', '500', '', '4', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Posting Freak', '1000', '', '5', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Moderator', '0', '', '6', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Super Moderator', '0', '', '7', 'yes', '')");
	$db->query("INSERT INTO $table[ranks] VALUES ('Administrator', '0', '', '8', 'yes', '')");
	echo "<b>Done</b><br />";

	$setting['sitename'] = addslashes($setting['sitename']);
	$setting['bbname'] = addslashes($setting['bbname']);

	echo "Inserting Default Data into $table[settings]...";
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'langfile', '$setting[lang]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bbname', '$setting[bbname]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'postperpage', 25)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'topicperpage', 30)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'hottopic', 20)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'theme', '$setting[theme]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bbstatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'newuseremail', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'whosonlinestatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'regstatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bboffreason', '')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'regviewonly', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'floodctrl', 5)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'memberperpage', 45)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'catsonly', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'hideprivate', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'emailcheck', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bbrules', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bbrulestxt', '')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'searchstatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'faqstatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'memliststatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'sitename', '$setting[sitename]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'siteurl', '$setting[siteurl]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'avastatus', 'two')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'u2uquota', 75)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'gzipcompress', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'boardurl', '$setting[boardurl]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'coppa', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'timeformat', '24')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'adminemail', '$setting[adminemail]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'dateformat', '$setting[dateform]')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'sigbbcode', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'sightml', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'reportpost', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'bbinsert', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'smileyinsert', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'doublee', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'smtotal', 16)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'smcols', 4)");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'editedby', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'dotfolders', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'attachimgpost', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'savelogsstatus', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'mostonline', '')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpnewnamestatus]', 'newnamestatus', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpusernamemin]', 'usernamemin', '0')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcustomstatus]', 'customstatus', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcstatusmin]', 'cstatusmin', '0')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpevalstatus]', 'evalstatus', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmonostatus]', 'monostatus', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpattachstatus]', 'attach_status', 'no')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmaxattachsize]', 'attach_size_max', '1048576')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmaxpostsize]', 'max_post_length', '8192')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcountryoffset]', 'countryoffset', '1')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarresizestatus]', 'avatarsize_resize', 'yes')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarheight]', 'avatarsize_max_height', '150')");
	$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarwidth]', 'avatarsize_max_width', '150')");
	echo "<b>Done</b><br />";

	echo "Inserting Default Data into $table[templates]...";
	$filesize = filesize("templates.bb");
	$fp = fopen("templates.bb", "r");
	$templatesfile = fread($fp, $filesize);
	fclose($fp);
	$templates = explode("|#*O2PHP TPL FILE*#|", $templatesfile);
	while (list($key, $val) = each($templates))
	{
		$template = explode("|#*O2PHP TPL*#|", $val);
		$template[1] = addslashes($template[1]);
		$db->query("INSERT INTO $table[templates] VALUES ('', '" . addslashes($template[0]) . "', '" . addslashes($template[1]). "')");
	}
	$db->query("DELETE FROM $table[templates] WHERE name=''");
	echo "<b>Done</b><br /><br />";

	echo "<b>Install successful!</b><br /><br /> The installation of Oxygen onto your server was successful. You can visit your board by clicking <a href=\"index.php\">here</a>.<br /><br />The Oxygen Team thanks you for using Oxygen";
}

?>
