<?
/*
$Id: setup.php,v 1.27 2002/06/07 11:01:44 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/
@include("./include/functions.inc.php");
@include("./include/widget.inc.php");
@include("./install/install.inc.php");

function checksetting($setting)
{
	global $PHP_SELF, $lang;

	$error = false;

	$errormsg = array();

	if($setting['dbhost'] == "")
	{
		$errormsg['dbhost'] = $lang['setupinvalid'];
	}

	if($setting['dbname'] == "")
	{
		$errormsg['dbname'] = $lang['setupinvalid'];
	}

	if($setting['dbuser'] == "")
	{
		$errormsg['dbuser'] = $lang['setupinvalid'];
	}

	if($setting['dbpw'] == "")
	{
		$errormsg['dbpw'] = $lang['setupinvalid'];
	}

	if($setting['adminemail'] == "")
	{
		$errormsg['adminemail'] = $lang['setupinvalid'];
	}

	if($setting['bbname'] == "")
	{
		$errormsg['bbname'] = $lang['setupinvalid'];
	}

	if($setting['boardurl'] == "" || $setting['boardurl'] == "http://")
	{
		$errormsg['boardurl'] = $lang['setupinvalid'];
	}

	if($setting['tablepre'] == "")
	{
		$errormsg['tablepre'] = $lang['setupinvalid'];
	}

	if($setting['lang'] == "")
	{
		$errormsg['lang'] = $lang['setupinvalid'];
	}

	return $errormsg;
}

function filecontent($name)
{
	$template = implode('', @file($name));
	return str_replace("\"", "\\\"", $template);
}

function configmaker($setting, $upload = "false")
{
	if($setting['tablepre'] == "")
	{
		$setting['tablepre'] = "o2_";
	}
	$setting['plug'] = stripslashes($setting['plug']);

	$cookie['domain'] = "." . ereg_replace("http://([^/<>[:space:]]+).*", "\\1", $setting['boardurl']);
	$cookie['path'] = eregi_replace("(http://[^/<>[:space:]]+)", "", $setting['boardurl']);
	if(strlen($cookie['path']) == 0)
	{
		$cookie['path'] = "/" . $cookie['path'];
	}

	$config_data = filecontent("install/config.inc.php");
	$config_data = str_replace("\\\"", "\"", $config_data);
	$patterns = array();
	$replacements = array();
	$patterns[0] = "[DB_NAME]";
	$replacements[0] = "$setting[dbname]";
	$patterns[1] = "[DB_USER]";
	$replacements[1] = "$setting[dbuser]";
	$patterns[2] = "[DB_PW]";
	$replacements[2] = "$setting[dbpw]";
	$patterns[3] = "[DB_HOST]";
	$replacements[3] = "$setting[dbhost]";
	$patterns[4] = "[TABLE_PRE]";
	$replacements[4] = "$setting[tablepre]";
	$patterns[5] = "[COOKIE_DOMAIN]";
	$replacements[5] = $cookie['domain'];
	$patterns[6] = "[COOKIE_PATH]";
	$replacements[6] = $cookie['path'];
	$patterns[7] = "[COOKIE_PREFIX]";
	$replacements[7] = $setting['cookiepre'];
	$patterns[8] = "[PLUG_LIST]";
	$replacements[8] = "$setting[plug]";
	$patterns[9] = "[CONF_UPLOADED]";
	$replacements[9] = $upload;

	$config_data = preg_replace($patterns, $replacements, $config_data);
	$config_data = str_replace("\r", "", $config_data);

	return $config_data;
}

function langlist($setting)
{
	$langfileselect = "<select name=\"setting[lang]\" onchange=\"if(this.options[this.selectedIndex].value != '') { window.location=('setup.php?setting[lang]='+this.options[this.selectedIndex].value) }\">\n";
	$dir = opendir("lang");
	while ($thafile = readdir($dir))
	{
		if(is_file("lang/$thafile") && $thafile != "index.php")
		{
			$thafile = str_replace(".lang.php", "", $thafile);
			if($setting['lang'] == $thafile)
			{
				$selected = " selected";
			}
			else
			{
				$selected = "";
			}
			$langfileselect .= "<option value=\"$thafile\"$selected>$thafile</option>\n";
		}
	}
	$langfileselect .= "</select>";
	return $langfileselect;
}

function themelist($setting)
{
	$themefileselect = "<select name=\"setting[theme]\">\n";
	$dir = opendir("images/themes");
	while ($thadir = readdir($dir))
	{
		if(is_dir("images/themes/$thadir") && $thadir != "." and $thadir != "..")
		{
			if($setting['theme'] == $thadir)
			{
				$selected = " selected";
			}
			else
			{
				$selected = "";
			}
			$themefileselect .= "<option value=\"$thadir\"$selected>$thadir</option>\n";
		}
	}
	$themefileselect .= "</select>";
	return $themefileselect;
}

function sendconfig($setting)
{
	$config_data = configmaker($setting, "true");
	header("Content-disposition: filename=config.php");
	header("Content-Length: ".strlen($config_data));
	header("Content-type: application/octetstream");
	header("Pragma: no-cache");
	header("Expires: 0");
	echo $config_data;
	exit;
}

function form($setting)
{
	global $PHP_SELF, $lang, $errormsg;

	$width = "20%";

	$langfileselect = langlist($setting);
	$template = filecontent("install/formulaire.inc.php");
	eval("\$formulaire = \"$template\";");

	html_header("Setup Oxygen Forum");
	echo $formulaire;
	html_footer();
}

$lang = array();
if(!file_exists("lang/$setting[lang].lang.php"))
{
	$setting['lang'] = "English";
}

@include("lang/$setting[lang].lang.php");

if(!isset($setting['action']) || !$setting['action'])
{
	if(!isset($setting['boardurl']))
	{
		$setting['boardurl'] = "http://" . $HTTP_SERVER_VARS['SERVER_NAME'] . ereg_replace("/setup\.php", "", $HTTP_SERVER_VARS['PHP_SELF']);
	}

	if(!isset($setting['siteurl']))
	{
		$setting['siteurl'] = "http://";
	}

	if(!isset($setting['tablepre']))
	{
		$setting['tablepre'] = "o2_";
	}

	if(!isset($setting['cookiepre']))
	{
		$setting['cookiepre'] = "Ox";
	}

	if(!isset($setting['lang']))
	{
		$setting['lang'] = "English";
	}

	if(!isset($setting['theme']))
	{
		$setting['theme'] = "Oxygen";
	}

	if(!isset($setting['dateform']))
	{
		$setting['dateform'] = "dd/mm/yyyy";
	}

	$setting['action'] = "install";
	form($setting);
	exit;
}

if(($errormsg = checksetting($setting)) != array())
{
	$setting['action'] = "install";
	form($setting);
	exit;	
}

if($setting['action'] == "install")
{
	@include("include/config.php");
	if(defined("O2_UPLOADED") && O2_UPLOADED)
	{
		html_header("Setup Oxygen Forum");
		echo "Creating include/config.php...";
		echo "<b>Done</b><br />";
		installer($setting, $lang);
		html_footer();
		exit;
	}

	@chmod ("include/config.php", 666);   
	$config = @fopen("include/config.php", "w+");
	if(!$config)
	{
		$config_data = configmaker($setting);
		sendconfig($setting);
		exit;
	}
	else
	{
		$config_data = configmaker($setting);
		@fwrite($config, $config_data);	
		@fclose($config);
		html_header("Setup Oxygen Forum");
		echo "Creating include/config.php...";
		echo "<b>Done</b><br />";
		installer($setting, $lang);
		html_footer();
		exit;
	}
}

?>
