<?
/*
$Id: toppost.php,v 1.3 2002/06/04 02:13:51 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/

/***
 * Toppost Settings
 */
// Here you have to fix the relative way to Oxygen path.
$OxyTop['path'] = "./";
// Here you have to fix the Oxygen URL.
$OxyTop['siteurl'] = "http://o2php.ath.cx";
// Here you have to fix the nimber of threads you want to be displayed.
$OxyTop['nbposts'] = 5;
// Here you have to fix the date format (PHP format) you want the date to be formatted.
$OxyTop['datefmt'] = "d/m/Y";
// Here you have to fix the background colour of the table.
$OxyTop['bgcolor'] = "#dee3e7";
// Here you have to choose (yes/no) if you want header to be displayed at the top of thread list.
$OxyTop['header'] = "yes";
// Here you have to choose language, must exist in Oxygen.
$OxyTop['lang'] = "French";

/***
 * Install
 * =======
 *
 * Just fill top values of this file.
 * Just copy this file in the directory you want to use Oxygen threads.
 * Add in the script you want to display threads :
 *		include("toppost.php");
 *
 * And just add following function call where you want threads to be displayed:
 *		TopPoster($OxyTop);
 *
 */

/*****************************************************************************/

function TopPoster($OxyTop)
{
	include($OxyTop['path'] . "/include/config.php");
	include($OxyTop['path'] . "/include/class/class.$database.inc.php");
	include($OxyTop['path'] . "/lang/" . $OxyTop['lang'] . ".lang.php");

	$db = new dbstuff;
	$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);

	$tables = array('forums','posts', 'threads');
	foreach($tables as $name)
	{
		$table["$name"] = $tablepre.$name;
	}

	echo("<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"80%\" align=\"center\">\n");
	if($OxyTop['header'] == "yes")
	{
		echo("	<tr bgcolor=\"$OxyTop[bgcolor]\">\n");
		echo("		<td align=\"center\" width=\"15\">&nbsp;</td>\n");
		echo("		<td>&nbsp;<b>$lang[textsubject]</b></td>\n");
		echo("		<td>&nbsp;<b>$lang[textdate]</b></td>\n");
		echo("		<td>&nbsp;<b>$lang[textauthor]</b></td>\n");
		echo("		<td>&nbsp;<b>$lang[textforum]</b></td>\n");
		echo("		<td>&nbsp;<b>$lang[textreplies]</b></td>\n");
		echo("		<td>&nbsp;<b>$lang[textviews]</b></td>\n");
		echo("	</tr>\n");
	}

	$query1 = $db->query("SELECT * FROM $table[threads] t, $table[forums] f WHERE t.fid=f.fid AND f.private='1' AND f.password='' AND f.userlist='' AND t.closed NOT LIKE '%moved%' ORDER BY t.lastpost DESC LIMIT 0, $OxyTop[nbposts]");
	while($thread = $db->fetch_assoc($query1))
	{
		if($thread['icon'])
		{
			$icon = "<img src=\"$OxyTop[siteurl]/images/smilies/$thread[icon]\" alt=\"icon\">\n";
		}
		else
		{
			$icon = "&nbsp;";
		}
		$thread['subject'] = stripslashes($thread['subject']);
		$thread['name'] = stripslashes($thread['name']);
		$lastpost = explode("|", $thread['lastpost']);
		$dateline = date($OxyTop['datefmt'], $lastpost[0]);
		$author = $lastpost[1];

		echo("	<tr bgcolor=\"$OxyTop[bgcolor]\">\n");
		echo("		<td align=\"center\" width=\"15\">$icon</td>\n");
		echo("		<td><a href=\"$OxyTop[siteurl]/viewthread.php?tid=$thread[tid]\">$thread[subject]</a></td>\n");
		echo("		<td align=\"center\">$dateline</td>\n");
		echo("		<td>&nbsp;$author</td>\n");
		echo("		<td>&nbsp;<a href=\"$OxyTop[siteurl]/forumdisplay.php?fid=$thread[fid]\">$thread[name]</a></td>\n");
		echo("		<td align=\"center\">$thread[replies]</td>\n");
		echo("		<td align=\"center\">$thread[views]</td>\n");
		echo("	</tr>\n");
	}

	echo("</table>");
}

?>
