<?
/*
$Id: upgrade.php,v 1.29 2002/06/07 11:01:27 eofredj Exp $

Oxygen v1.0.4
2002 Oxygen Development Team

Please see GPL.txt in the docs directory of this distribution.

File Last Updated:
02-06-15 18:55:36

*/
@include("./include/functions.inc.php");
@include("./include/widget.inc.php");

@set_time_limit (1000);

$lang['config'] = "Update config.php file <font size=\"-2\">(must be writable: chmod 0666)?";
$lang['smilies'] = "Insert new smilies ?";
$lang['themes'] = "Insert new themes ?";
$lang['templates'] = "Insert new templates <font size=\"-2\">(You really should check it)?";
$lang['password'] = "DB password :";
$lang['done'] = "<td width=\"50%\" align=\"center\"><b>Done</b></td>";

function filecontent($name)
{
	if(file_exists($name))
	{
		$template = implode('', @file($name));
		return str_replace("\\'", "'", $template);
	}
	else
	{
		return false;
	}
}

function configfile($from, $to)
{
	global $HTTP_SERVER_VARS;

	if($from <= "020309-0302" && $to > "020309-0302")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Changing config.php to its new format...</td>\n";

		@include("./config.php");
		if($config_data = filecontent("install/config.inc.php"))
		{
			$config_data = stripslashes($config_data);

			$pluglist = "";
			for($i = 1; $i <= count($plugname); $i++)
			{
				if($plugurl[$i] == "today.php")
				{
					$plugname[$i] = "Lastposts";
					$plugurl[$i] = "lastpost.php";
				}
				$pluglist .= '$plug[\'name\'][' . $i . '] = "' . $plugname[$i] . "\";\n";
				$pluglist .= '$plug[\'url\'][' . $i . '] = "' . $plugurl[$i] . "\";\n";
				$pluglist .= '$plug[\'admin\'][' . $i . '] = "' . $plugadmin[$i] . "\";\n";
			}

			$patterns = array();
			$replacements = array();
			$patterns[0] = "[DB_NAME]";
			$replacements[0] = "$dbname";
			$patterns[1] = "[DB_USER]";
			$replacements[1] = "$dbuser";
			$patterns[2] = "[DB_PW]";
			$replacements[2] = "$dbpw";
			$patterns[3] = "[DB_HOST]";
			$replacements[3] = "$dbhost";
			$patterns[4] = "[TABLE_PRE]";
			$replacements[4] = "$tablepre";
			$patterns[5] = "[COOKIE_DOMAIN]";
			$replacements[5] = "$cookiedomain";
			$patterns[6] = "[COOKIE_PATH]";
			$replacements[6] = "$cookiepath";
			$patterns[7] = "[PLUG_LIST]";
			$replacements[7] = "$pluglist";
			$config_data = preg_replace($patterns, $replacements, $config_data);
			$config_data = str_replace("\r", "", $config_data);

			$config = @fopen("./config.php", "w+");
			if($config)
			{
				@fwrite($config, $config_data);	
				@fclose($config);
				echo "$lang[done]</tr>";
			}
			else
			{
				echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't write config.php</font></b></td></tr>";
				html_footer();
				exit;
			}
		}
		else
		{
			echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't open config.php</font></b></td></tr>";
			html_footer();
			exit;
		}
	}

	if($from <= "020322-1753" && $to > "020322-1753")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Copying config.php in its new directory...</td>\n";
		if($config_data = filecontent("./config.php"))
		{
			$config_data = stripslashes($config_data);
			$config = @fopen("include/config.php", "w+");
			if($config)
			{
				@fwrite($config, $config_data);	
				@fclose($config);
				echo "$lang[done]</tr>";
			}
			else
			{
				echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't write include/config.php</font></b></td></tr>";
				html_footer();
				exit;
			}
		}
		else
		{
			echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't open config.php</font></b></td></tr>";
			html_footer();
			exit;
		}
	}

	if($from <= "020425-0625" && $to > "020425-0625")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying config.php ...</td>\n";
		@include("./include/config.php");
		if($config_data = filecontent("install/config.inc.php"))
		{
			$config_data = stripslashes($config_data);

			$pluglist = "";
			for($i = 1; $i <= count($plug['name']); $i++)
			{
				$pluglist .= '$plug[\'name\'][' . $i . '] = "' . $plug['name'][$i] . "\";\n";
				$pluglist .= '$plug[\'url\'][' . $i . '] = "' . $plug['url'][$i] . "\";\n";
				$pluglist .= '$plug[\'admin\'][' . $i . '] = "' . $plug['admin'][$i] . "\";\n";
			}

			$boardurl = "http://" . $HTTP_SERVER_VARS['SERVER_NAME'] . ereg_replace("/upgrade\.php", "", $HTTP_SERVER_VARS['PHP_SELF']);
			$cookie['domain'] = "." . ereg_replace("http://([^/<>[:space:]]+).*", "\\1", $boardurl);
			$cookie['path'] = eregi_replace("(http://[^/<>[:space:]]+)", "", $boardurl);
			if(strlen($cookie['path']) == 0)
			{
				$cookie['path'] = "/" . $cookie['path'];
			}

			$patterns = array();
			$replacements = array();
			$patterns[0] = "[DB_NAME]";
			$replacements[0] = "$dbname";
			$patterns[1] = "[DB_USER]";
			$replacements[1] = "$dbuser";
			$patterns[2] = "[DB_PW]";
			$replacements[2] = "$dbpw";
			$patterns[3] = "[DB_HOST]";
			$replacements[3] = "$dbhost";
			$patterns[4] = "[TABLE_PRE]";
			$replacements[4] = "$tablepre";
			$patterns[5] = "[COOKIE_DOMAIN]";
			$replacements[5] = $cookie['domain'];
			$patterns[6] = "[COOKIE_PATH]";
			$replacements[6] = $cookie['path'];
			$patterns[7] = "[COOKIE_PREFIX]";
			$replacements[7] = "Ox";
			$patterns[8] = "[PLUG_LIST]";
			$replacements[8] = "$pluglist";
			$patterns[9] = "[CONF_UPLOADED]";
			$replacements[9] = "true";
			$config_data = preg_replace($patterns, $replacements, $config_data);
			$config_data = str_replace("\r", "", $config_data);

			$config = @fopen("./include/config.php", "w+");
			if($config)
			{
				@fwrite($config, $config_data);	
				@fclose($config);
				echo "$lang[done]</tr>";
			}
			else
			{
				echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't write config.php</font></b></td></tr>";
				html_footer();
				exit;
			}
		}
		else
		{
			echo "<td width=\"50%\" align=\"center\"><b><font color=\"red\">Can't open config.php</font></b></td></tr>";
			html_footer();
			exit;
		}
	}
}

function createbox($from, $to)
{
	global $db, $table;

	if($from <= "011201-0000" && $to > "011201-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating $table[box]...</td>\n";
		$db->query("DROP TABLE IF EXISTS $table[box]");
		$db->query("CREATE TABLE $table[box] (
			id int(11) NOT NULL auto_increment,
			name text NOT NULL,
			mesg text NOT NULL,
			time int(11) NOT NULL default '0',
			PRIMARY KEY (id)
		) TYPE=MyISAM;");
		echo "$lang[done]</tr>";
	}
}

function createignore($from, $to)
{
	global $db, $table;

	if($from <= "011215-0000" && $to > "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating $table[ignore]...</td>\n";
		$db->query("DROP TABLE IF EXISTS $table[ignore]");
		$db->query("CREATE TABLE $table[ignore] (
			username text NOT NULL,
			ignorename text NOT NULL,
			KEY username (username)
		) TYPE=MyISAM;");
		echo "$lang[done]</tr>";
	}
}

function createlog($from, $to)
{
	global $db, $table;

	if($from <= "011215-0000" && $to > "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating $table[log]...</td>\n";
		$db->query("DROP TABLE IF EXISTS $table[log]");
		$db->query("CREATE TABLE $table[log] (
			username varchar(25) NOT NULL,
			ip text NOT NULL,
			time int(11) NOT NULL default '0',
			url text NOT NULL
		) TYPE=MyISAM;");
		echo "$lang[done]</tr>";
	}
}

function createnews($from, $to)
{
	global $db, $table;

	if($from <= "020219-2338" && $to > "020219-2338")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating $table[news]...</td>\n";
		$db->query("DROP TABLE IF EXISTS $table[news]");
		$db->query("CREATE TABLE $table[news] (
			nid smallint(6) NOT NULL auto_increment,
			author varchar(40) NOT NULL default '',
			dateline bigint(30) NOT NULL default '0',
			subject varchar(120) NOT NULL default '',
			msg text NOT NULL default '',
			PRIMARY KEY (nid)
		) TYPE=MyISAM;");
		echo "$lang[done]</tr>";
	}
}

function createplugin($from, $to)
{
	global $db, $table;

	if($from <= "020522-0243" && $to > "020522-0243")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating $table[plugins]...</td>\n";
		$db->query("DROP TABLE IF EXISTS $table[plugins]");
		$db->query("CREATE TABLE $table[plugins] (
			plid bigint(20) NOT NULL auto_increment,
			name varchar(25) NOT NULL default '',
			url varchar(75) NOT NULL default '',
			installed char(3) NOT NULL default 'no',
			active char(3) NOT NULL default 'yes',
			ptable varchar(25) NOT NULL default '',
			admin char(3) NOT NULL default 'yes',
			porder smallint(6) NOT NULL default '0',
			PRIMARY KEY (plid)
		) TYPE=MyISAM;");
		echo "$lang[done]</tr>";
	}
}

function modifyforums($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[forums]...</td>\n";
		$db->query("ALTER TABLE $table[forums] CHANGE allowhtml allowhtml char(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] CHANGE allowsmilies allowsmilies char(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] CHANGE allowbbcode allowbbcode char(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] CHANGE postperm postperm char(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] CHANGE allowimgcode allowimgcode varchar(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] ADD guestposting char(3) NOT NULL default ''");
		echo "$lang[done]</tr>";
	}

	if($from <= "020223-1130" && $to > "020223-1130")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[forums]...</td>\n";
		$db->query("ALTER TABLE $table[forums] CHANGE attachstatus attachstatus char(3) NOT NULL");
		$db->query("ALTER TABLE $table[forums] CHANGE pollstatus pollstatus char(3) NOT NULL");
		echo "$lang[done]</tr>";
	}
}

function modifyignore($from, $to)
{
	global $db, $table;

	if($from <= "020215-0227" && $to > "020215-0227")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[ignore]...</td>\n";
		$db->query("ALTER TABLE $table[ignore] CHANGE username username varchar(25) NOT NULL");
		$db->query("ALTER TABLE $table[ignore] CHANGE ignorename ignorename varchar(25) NOT NULL");
		echo "$lang[done]</tr>";
	}
}

function modifylog($from, $to)
{
	global $db, $table;

	if($from <= "020215-0227" && $to > "020215-0227")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[log]...</td>\n";
		$db->query("ALTER TABLE $table[log] CHANGE username username VARCHAR(25) NOT NULL");
		echo "$lang[done]</tr>";
	}

	if($from <= "020425-0625" && $to > "020425-0625")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[log]...</td>\n";
		$db->query("ALTER TABLE $table[log] ADD lid bigint(6) NOT NULL auto_increment primary key first");
		echo "$lang[done]</tr>";
	}

	if($from <= "020520-1751" && $to > "020520-1751")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[log]...</td>\n";
		$db->query("ALTER TABLE $table[log] CHANGE lid lid bigint(6) NOT NULL auto_increment");
		echo "$lang[done]</tr>";
	}
}

function modifymembers($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[members]...</td>\n";
		$db->query("ALTER TABLE $table[members] CHANGE newsletter newsletter varchar(3) NOT NULL");
		echo "$lang[done]</tr>";
	}

	if($from <= "011215-0000" && $to > "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[members]...</td>\n";
		$db->query("ALTER TABLE $table[members] ADD rating blob NOT NULL");
		$db->query("ALTER TABLE $table[members] ADD realname varchar(30) default NULL");
		$db->query("ALTER TABLE $table[members] ADD firstname varchar(30) default NULL");
		$db->query("ALTER TABLE $table[members] ADD emailnotify char(3) NOT NULL default ''");
		$db->query("ALTER TABLE $table[members] ADD profileviews int(10) NOT NULL default '0'");
		$db->query("ALTER TABLE $table[members] ADD u2upopup char(3) NOT NULL default 'no'");
		$db->query("ALTER TABLE $table[members] ADD chatpopup int(5) NOT NULL default '0'");
		echo "$lang[done]</tr>";
	}

	if($from <= "020225-1432" && $to > "020225-1432")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[members]...</td>\n";
		$db->query("ALTER TABLE $table[members] CHANGE lastvisit lastvisit bigint(30) NOT NULL default '0'");
		echo "$lang[done]</tr>";
	}

	if($from <= "020425-0625" && $to > "020425-0625")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[members]...</td>\n";
		$db->query("ALTER TABLE $table[members] CHANGE customstatus customstatus varchar(250) NOT NULL default '0'");
		echo "$lang[done]</tr>";
	}
}

function modifyposts($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[posts]...</td>\n";
		$db->query("ALTER TABLE $table[posts] DROP attach");
		echo "$lang[done]</tr>";
	}
}

function modifysettings($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$db->query("ALTER TABLE $table[settings] ADD editedby char(3) NOT NULL default ''");
		$db->query("ALTER TABLE $table[settings] ADD dotfolders char(3) NOT NULL default ''");
		$db->query("ALTER TABLE $table[settings] ADD attachimgpost char(3) NOT NULL default ''");
		echo "$lang[done]</tr>";
	}

	if($from == "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$db->query("ALTER TABLE $table[settings] DROP usercstatus");
		echo "$lang[done]</tr>";
	}

	if($from <= "011215-0000" && $to > "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$db->query("ALTER TABLE $table[settings] ADD newuseremail char(3) NOT NULL default '' after bbstatus");
		echo "$lang[done]</tr>";
	}

	if($from <= "020215-0227" && $to > "020215-0227")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$db->query("ALTER TABLE $table[settings] ADD savelogsstatus varchar(3) NOT NULL");
		echo "$lang[done]</tr>";
	}

	if($from <= "020223-1130" && $to > "020223-1130")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Upgrading Default Data into $table[settings]... </td>\n";
		$value="";
		$comma="";
		$query = $db->query("SELECT * FROM $table[settings]");
		$setting = $db->fetch_assoc($query);
		foreach($setting as $key => $val)
		{
			$$key = $val;
			if($val == "on")
			{
				$setting[$key] = "yes";
			}
			elseif ($val == "off")
			{
				$setting[$key] = "no";
			}
			$value .= "$comma$key='" . addslashes($setting[$key]) . "'";
			$comma = ",\n ";
		}
		$db->query("UPDATE $table[settings] SET " . $value . " WHERE bbname != ''");
		echo "$lang[done]</tr>";
	}

	if($from <= "020425-0625" && $to > "020425-0625")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$query = $db->query("SELECT * FROM $table[settings]");
		$setting = $db->fetch_assoc($query);
		foreach($setting as $variable => $value)
		{
			$settings[$variable] = htmlspecialchars(stripslashes(trim($value)));
		}
		$db->query("DROP TABLE IF EXISTS $table[settings]");
		$db->query("CREATE TABLE $table[settings] (
			sid smallint(6) NOT NULL auto_increment,
			status varchar(35) NOT NULL default '',
			users text,
			name text NOT NULL,
			variable varchar(20) NOT NULL default '',
			value text NOT NULL,
			PRIMARY KEY (sid)
		) TYPE=MyISAM;");
		foreach($settings as $key => $item)
		{
			$item = addslashes(trim($item));
			$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', '$key', '$item');");
		}
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpnewnamestatus]', 'newnamestatus', 'no')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpusernamemin]', 'usernamemin', '0')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcustomstatus]', 'customstatus', 'no')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcstatusmin]', 'cstatusmin', '0')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpevalstatus]', 'evalstatus', 'no')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmonostatus]', 'monostatus', 'no')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpattachstatus]', 'attach_status', 'no')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmaxattachsize]', 'attach_size_max', '1048576')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpmaxpostsize]', 'max_post_length', '8192')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpcountryoffset]', 'countryoffset', '1')");
		echo "$lang[done]</tr>";
	}

	if($from <= "020522-0243" && $to > "020522-0243")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[settings]...</td>\n";
		$db->query("ALTER TABLE $table[settings] CHANGE variable variable varchar(50) NOT NULL default ''");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarresizestatus]', 'avatarsize_resize', 'yes')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarheight]', 'avatarsize_max_height', '150')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', 'lang[cpavatarwidth]', 'avatarsize_max_width', '150')");
		$db->query("INSERT INTO $table[settings] VALUES ('', 'Administrator', '', '', 'mostonline', '')");
		echo "$lang[done]</tr>";
	}
}

function modifythemes($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[themes]...</td>\n";
		$db->query("ALTER TABLE $table[themes] ADD cattext varchar(15) NOT NULL default ''");
		echo "$lang[done]</tr>";
	}

	if($from <= "011215-0000" && $to > "011215-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[themes]...</td>\n";
		$db->query("ALTER TABLE $table[themes] ADD dummy TINYINT NOT NULL AFTER link;");
		echo "$lang[done]</tr>";
	}
}

function modifyu2u($from, $to)
{
	global $db, $table;

	if($from <= "011101-0000" && $to > "011101-0000")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[u2u]...</td>\n";
		$db->query("ALTER TABLE $table[u2u] ADD new char(3) NOT NULL default ''");
		echo "$lang[done]</tr>";
	}

	if($from <= "020219-0402" && $to > "020219-0402")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[u]2u...</td>\n";
		$db->query("ALTER TABLE $table[u2u] CHANGE new isnew char(3) NOT NULL default ''");
		echo "$lang[done]</tr>";
	}
}

function upgrademembers($from, $to)
{
	global $db, $table;

	if($from <= "020223-1130" && $to > "020223-1130")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Modifying $table[members]...</td>\n";
		$db->query("UPDATE `$table[members]` SET `avatar` = '' WHERE `avatar` LIKE '%clear_avatar.gif'");
		echo "$lang[done]</tr>";
	}
}

function upgradeforums($from, $to)
{
	global $db, $table;

	if($from <= "020223-1130" && $to > "020223-1130")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Upgrading Default Data into $table[forums]... </td>\n";
		$query = $db->query("SELECT * FROM $table[forums] WHERE (status='on' OR attachstatus='on' OR pollstatus='on' OR guestposting='on' OR status='off' OR attachstatus='off' OR pollstatus='off' OR guestposting='off')");
		while($forum = $db->fetch_assoc($query))
		{
			$value="";
			$comma="";
			foreach($forum as $key => $val)
			{
				$$key = $val;
				if($val == "on")
				{
					$forum[$key] = "yes";
				}
				elseif ($val == "off")
				{
					$forum[$key] = "no";
				}
				$value .= "$comma$key='".addslashes($forum[$key])."'";
				$comma = ", ";
			}
			$db->query("UPDATE $table[forums] SET " . $value . " WHERE fid='".$forum['fid']."'");
		}
		echo "$lang[done]</tr>";
	}
}

function upgradeplugins($from, $to)
{
	global $db, $table;

	if($from <= "020522-0243" && $to > "020522-0243")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Inserting Default Data into $table[plugins]...</td>\n";
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textsettings]', 'settings', 'yes', 'yes', 'settings', 'yes', 1)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textforums]', 'forum', 'yes', 'yes', 'forums', 'yes', 2)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textmods]', 'mods', 'yes', 'yes', '', 'yes', 3)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textmembers]', 'members', 'yes', 'yes', 'members', 'yes', 4)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textipban]', 'ipban', 'yes', 'yes', 'banned', 'yes', 5)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textupgrade]', 'upgrade', 'yes', 'yes', '', 'yes', 6)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[themes]', 'themes', 'yes', 'yes', 'themes', 'yes', 7)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[smilies]', 'smilies', 'yes', 'yes', 'smilies', 'yes', 8)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textcensors]', 'censor', 'yes', 'yes', 'words', 'yes', 9)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textuserranks]', 'ranks', 'yes', 'yes', 'ranks', 'yes', 10)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textnewsletter]', 'newsletter', 'yes', 'yes', '', 'yes', 11)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textprune]', 'prune', 'yes', 'yes', '', 'yes', 12)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[templates]', 'templates', 'yes', 'yes', 'templates', 'yes', 13)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[textattachman]', 'attachments', 'yes', 'yes', 'attachments', 'yes', 14)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[fmheader]', 'filemgr', 'yes', 'yes', '', 'yes', 15)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[logsystem]', 'log', 'yes', 'yes', 'log', 'yes', 16)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[prunemembers]', 'prunemembers', 'yes', 'yes', '', 'yes', 17)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'Plugins', 'plugins', 'yes', 'yes', 'plugins', 'yes', 18)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[plugoptimize]', 'optimize', 'yes', 'yes', '', 'yes', 19)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'lang[fixtitle]', 'fix', 'yes', 'yes', '', 'yes', 20)");
		$db->query("INSERT INTO $table[plugins] VALUES ('', 'Forum Status', 'status', 'yes', 'yes', '', 'yes', 21)");
		echo "$lang[done]</tr>";
	}
}

function upgradesettings($from, $to)
{
	global $db, $table;

}

function upgradesmilies($from, $to)
{
	global $db, $table;

	echo "<tr><td width=\"50%\" align=\"center\">Upgrading Default Data into $table[smilies]... </td>\n";
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':grin:', 'biggrin2.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'biggrin2.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-?', 'confused.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'confused.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', '8)', 'icon_cool.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'icon_cool.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':lol:', 'lol.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'lol.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-p', 'razz.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'razz.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':-o', 'icon_rolleyes.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'icon_rolleyes.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':ange:', 'ange.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'ange.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':x', 'icon_mad.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'icon_mad.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun:', 'gun.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':eek:', 'eek.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun1:', 'gun1.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun2:', 'gun2.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun3:', 'gun3.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun4:', 'gun4.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun5:', 'gun5.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':gun6:', 'gun6.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'no.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':up:', 'up.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':hot:', 'hot.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':no:', 'no.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':eldiablo:', 'diablotin.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'diablotin.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':sleep:', 'sleep.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'sleep.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('smiley', ':love:', 'love.gif', '')");
	$db->query("INSERT INTO $table[smilies] VALUES ('picon', '', 'love.gif', '')");
	echo "$lang[done]</tr>";
}

function upgradetemplates($from, $to)
{
	global $db, $table;

	echo "<tr><td width=\"50%\" align=\"center\">Upgrading Default Data into $table[templates]... </td>\n";
	$db->query("DELETE FROM $table[templates]");
	$filesize = filesize('templates.bb');
	$fp = fopen('templates.bb','r');
	$templatesfile = fread($fp,$filesize);
	fclose($fp);
	$templates = explode("|#*O2PHP TPL FILE*#|", $templatesfile);
	while (list($key, $val) = each($templates))
	{
		$template = explode("|#*O2PHP TPL*#|", $val);
		$template[1] = addslashes($template[1]);
		$db->query("INSERT INTO $table[templates] VALUES ('',  '".addslashes($template[0])."', '".addslashes($template[1])."')");
	}
	$db->query("DELETE FROM $table[templates] WHERE name=''");
	echo "$lang[done]</tr>";
}

function upgradethemes($from, $to)
{
	global $db, $table;

	if($from <= "020223-1130" && $to > "020223-1130")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Upgrading Default Data into $table[themes]... </td>\n";
		$db->query("INSERT INTO $table[themes] VALUES ('Oxygen', '#ffffff', '#a2d6ea', '#c9e9ea', '#995533', 0, '#778899', '#9daeea', '#002200', '#ffffff', '#9acef6', '#003300', '#000080', '1', '100%', '2', 'Verdana', '11px', 'Oxygen.jpg', 'images/themes/Oxygen', 'images/smilies', '#550055')");
		echo "$lang[done]</tr>";
	}
}

function createindex($from, $to)
{
	global $db, $table;

	if($from <= "020216-2118" && $to >= "020216-2118")
	{
		echo "<tr><td width=\"50%\" align=\"center\">Creating Default Index... </td>\n";
		$db->query("CREATE index tid on $table[attachments] (tid);");
		$db->query("CREATE index pid on $table[attachments] (pid);");
		$db->query("CREATE index ip1 on $table[banned] (ip1);");
		$db->query("CREATE index ip2 on $table[banned] (ip2);");
		$db->query("CREATE index ip3 on $table[banned] (ip3);");
		$db->query("CREATE index ip4 on $table[banned] (ip1);");
		$db->query("CREATE index id on $table[box] (id);");
		$db->query("CREATE index fup on $table[forums] (fup);");
		$db->query("CREATE index type on $table[forums] (type);");
		$db->query("CREATE index private on $table[forums] (private);");
		$db->query("CREATE index status on $table[forums] (status);");
		$db->query("CREATE index username on $table[ignore] (username(25));");
		$db->query("CREATE index lid on $table[log] (lid);");
		$db->query("CREATE index time on $table[log] (time);");
		$db->query("CREATE index username on $table[members] (username(25));");
		$db->query("CREATE index status on $table[members] (status(35));");
		$db->query("CREATE index nid on $table[news] (nid);");
		$db->query("CREATE index fid on $table[posts] (fid);");
		$db->query("CREATE index tid on $table[posts] (tid);");
		$db->query("CREATE index dateline on $table[posts] (dateline);");
		$db->query("CREATE index title on $table[ranks] (title);");
		$db->query("CREATE index sid on $table[settings] (sid);");
		$db->query("CREATE index name on $table[templates] (name);");
		$db->query("ALTER TABLE $table[themes] DROP PRIMARY KEY:");
		$db->query("ALTER TABLE $table[themes] ADD PRIMARY KEY(name);");
		$db->query("CREATE index fid on $table[threads] (fid);");
		$db->query("CREATE index tid on $table[threads] (tid);");
		$db->query("CREATE index msgto on $table[u2u] (msgto);");
		$db->query("CREATE index username on $table[whosonline] (username);");
		$db->query("CREATE index find on $table[words] (find);");
		echo "$lang[done]</tr>";
	}

	if($from <= "020522-0243" && $to > "020522-0243")
	{
		$db->query("CREATE index find on $table[plugins] (plid);");
	}
}

function checkfiles($path)
{
	$goodfiles = array(".", "..", "admin", "docs", "images", "include", "install", "lang", "plugins", "buddy.php", "chatterbox.php", "codebuttons.js", "cp.php", "editprofile.php", "emailfriend.php", "fadertcw.js", "faq.php", "forumdisplay.php", "header.php", "ignore.php", "index.php", "lastpost.php", "license.php", "member.php", "memcp.php", "misc.php", "moresmilies.php", "news.php", "post.php", "setup.php", "stats.php", "templates.bb", "topicadmin.php", "toppost.php", "transfer.php", "u2u.php", "upgrade.php",  "viewthread.php");

	$obsoletefiles = "";
	$directory = dir($path);
	while(false !== ($entry = $directory->read()))
	{
		if(in_array($entry, $goodfiles))
		{
			continue;
		}
		$Prefix = "";
		if(is_dir($entry))
		{
			$Prefix = "<font color=\"red\">Directory :</font>	(";
		}
		else
		{
			$Prefix = "<font color=\"blue\">File :</font>	(";
		}
		$obsoletefiles .= "$Prefix$entry)<br>\n";
	}
	$directory->close();
	return $obsoletefiles;
}

function success($from, $to)
{
	echo "<tr><td colspan=\"2\" align=\"center\"><b>Upgrade from $from to $to successful!</b><br /><br />\n";
	echo "The upgrade of Oxygen onto your server was successful. You can visit your board by clicking <a href=\"index.php\">here</a>.<br /><br />The Oxygen Team thanks you for using Oxygen.</td></tr>\n";

	$obsoletefiles = checkfiles(".");
	if($obsoletefiles != "")
	{
		echo "<tr><td colspan=\"2\" align=\"left\"><b>These items are obsolete, you should remove them.</b></td></tr>\n";
		echo "<tr><td colspan=\"2\" align=\"left\">$obsoletefiles</td></tr>\n";
	}
	echo "</table>\n";
}

html_header("Upgrade Oxygen Forum");

if(isset($verfrom) && isset($verto) && $verfrom != "" && $verto != "")
{
	if($verfrom <= $verto)
	{
		if(file_exists("./include/config.php"))
		{
			@include "./include/config.php";
		}
		
		if(file_exists("./config.php") && ($dbpw == "" || $dbpw == "DB_PW"))
		{
			@include "./config.php";
		}

		echo "<table cellspacing=\"0\" cellpadding=\"1\" border=\"0\" width=\"100%\" align=\"center\">\n";
		echo "<tr><td>\n";

		if(!isset($instpw) || $instpw != $dbpw)
		{
			echo "<input type=\"hidden\" name=\"config\" value=\"$config\">\n";
			echo "<input type=\"hidden\" name=\"themes\" value=\"$themes\">\n";
			echo "<input type=\"hidden\" name=\"smilies\" value=\"$smilies\">\n";
			echo "<input type=\"hidden\" name=\"templates\" value=\"$templates\">\n";
			echo "<input type=\"hidden\" name=\"verfrom\" value=\"$verfrom\">\n";
			echo "<input type=\"hidden\" name=\"verto\" value=\"$verto\">\n";

			echo "<table cellspacing=\"1\" cellpadding=\"2\" border=\"0\" width=\"100%\" align=\"center\">\n";
			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$lang[password]</td>\n";
			echo "	<td width=\"50%\" align=\"center\"><input type=\"password\" size=20 name=\"instpw\" value=\"$instpw\"></td>\n";
			echo "</tr>\n";
			echo "<tr>\n";
			echo "	<td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"Upgrade\"></td>\n";
			echo "</tr>\n";
			echo "</table>\n";
			html_footer();
			exit;
		}

		echo "<table cellspacing=\"1\" cellpadding=\"2\" border=\"0\" width=\"100%\" align=\"center\">\n";
		echo "<tr><td width=\"50%\" align=\"center\">\n";
		echo "Your present version : $verfrom";
		echo "</td>\n";
		echo "<td width=\"50%\" align=\"center\">\n";
		echo "Your wanted version : $verto<br />";
		echo "</td></tr>\n";

		if($config == "yes" && !((defined("O2_UPLOADED") && O2_UPLOADED)))
		{
			configfile($verfrom, $verto);
		}
		else
		{
			$config = "no";
			echo "<tr><td width=\"50%\" align=\"center\">$lang[config]</td>\n";
			echo "<td width=\"50%\" align=\"center\">\n";
			echo "$config</td></tr>\n";
		}

		if(file_exists("./include/config.php"))
		{
			include "./include/config.php";
		}

		include("./include/class/class.$database.inc.php");
		$db = new dbstuff;
		$db->connect($dbhost, $dbuser, $dbpw, $dbname, $pconnect);

		$tables = array('attachments', 'banned', 'box', 'buddys', 'favorites', 'forums', 'ignore', 'log', 'members', 'news', 'plugins', 'posts', 'ranks', 'settings', 'smilies', 'templates', 'themes', 'threads', 'u2u',  'whosonline', 'words');
		foreach($tables as $name)
		{
			$table["$name"] = $tablepre.$name;
		}

		if($themes == "yes")
		{
			upgradethemes($verfrom, $verto);
		}
		else
		{
			$themes = "no";
			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$lang[themes]</td>\n";
			echo "	<td width=\"50%\" align=\"center\">$themes</td>\n";
			echo "</tr>\n";
		}

		if($smilies == "yes")
		{
			upgradesmilies($verfrom, $verto);
		}
		else
		{
			$smilies = "no";
			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$lang[smilies]</td>\n";
			echo "	<td width=\"50%\" align=\"center\">$smilies</td>\n";
			echo "</tr>\n";
		}

		if($templates == "yes")
		{
			upgradetemplates($verfrom, $verto);
		}
		else
		{
			$templates = "no";
			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$lang[templates]</td>\n";
			echo "	<td width=\"50%\" align=\"center\">$templates</td>\n";
			echo "</tr>\n";
		}

		if($verfrom < $verto)
		{
			createbox($verfrom, $verto);
			createignore($verfrom, $verto);
			createlog($verfrom, $verto);
			createnews($verfrom, $verto);
			createplugin($verfrom, $verto);
			modifyforums($verfrom, $verto);
			modifyignore($verfrom, $verto);
			modifylog($verfrom, $verto);
			modifymembers($verfrom, $verto);
			modifyposts($verfrom, $verto);
			modifysettings($verfrom, $verto);
			modifythemes($verfrom, $verto);
			modifyu2u($verfrom, $verto);
			upgradeforums($verfrom, $verto);
			upgrademembers($verfrom, $verto);
			upgradeplugins($verfrom, $verto);
			upgradesettings($verfrom, $verto);
			createindex($verfrom, $verto);
		}
		success($verfrom, $verto);
	}
}
else
{

	echo "<table cellspacing=\"0\" cellpadding=\"1\" border=\"0\" width=\"100%\" align=\"center\">\n";
	echo "<tr><td colspan=\"2\" align=\"center\">\n";
	echo "	<a href=\"$PHP_SELF\" alt=\"Go back\"><b>Upgrade</b></a> | \n";
	echo "	<a href=\"setup.php\" alt=\"Go Setup\"><b>Setup</b></a> | \n";
	echo "	<a href=\"license.php\"><b>License Terms</b></a>\n";
	echo "</td></tr>\n";
	echo "<tr>\n";
	echo "	<td colspan=\"2\" align=\"center\">You can just restore template if you select present version = destination version.</td>\n";
	echo "</tr>\n";
	echo "<tr><td>\n";

	$filever = "docs/o2php_versions.txt";
	if(file_exists($filever))
	{
		if(!is_readable($filever))
		{
			echo "<table cellspacing=\"1\" cellpadding=\"2\" border=\"0\" width=\"100%\" align=\"center\">\n";
			echo "<tr>\n";
			echo "	<td align=\"center\"><h3><font color=\"red\"><b>Can't read/open \"$filever\"</b></font></h3></td>\n";
			echo "</tr>";
			echo "</table>\n";
			html_footer();
			exit();
		}
		else
		{
			$fp = fopen($filever, "r");
			$fromver = "<select name=\"verfrom\">\n";
			$tover = "<select name=\"verto\">\n";
			$fromver .= "<option value=\"\" selected=\"selected\">Select your present version</option>\n";
			$tover .=  "<option value=\"\" selected=\"selected\">Select your destination version</option>\n";
			$fromver .= "<option value=\"011101-0000\">xmb-1.5rc3</option>\n";
			$fromver .= "<option value=\"011201-0000\">xmb-1.5rc5</option>\n";
			$fromver .= "<option value=\"011215-0000\">xmb-silver</option>\n";
			while(!feof($fp))
			{
				$buffer = fgets($fp, 256);
				$version = exploder($buffer, "|");
				if($version[0] != "")
				{
					$ver = $version[0];
					$name = $version[1];
					$fromver .= "<option value=\"$ver\">$name</option>\n";
				}
			}
			fclose($fp);
			$tover .= "<option value=\"$ver\">$name</option>\n";
			$fromver .= "</select>";
			$tover .= "</select>";
			echo "<table cellspacing=\"1\" cellpadding=\"2\" border=\"0\" width=\"100%\" align=\"center\">\n";
			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$fromver</td>\n";
			echo "	<td width=\"50%\" align=\"center\">$tover</td>\n";
			echo "</tr>\n";

			$checkbox = array("config", "themes", "smilies", "templates");
			foreach($checkbox as $item)
			{
				echo "<tr>\n";
				echo "	<td width=\"50%\" align=\"center\">$lang[$item]</td>\n";
				echo "	<td width=\"50%\" align=\"center\"><input type=\"checkbox\" name=\"$item\" value=\"yes\"></td>\n";
				echo "</tr>\n";
			}

			echo "<tr>\n";
			echo "	<td width=\"50%\" align=\"center\">$lang[password]</td>\n";
			echo "	<td width=\"50%\" align=\"center\"><input type=\"password\" size=20 name=\"instpw\" value=\"\"></td>\n";
			echo "</tr>\n";

			echo "<tr>\n";
			echo "	<td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"Upgrade\"></td>\n";
			echo "</tr>\n";
			echo "</table>\n";
		}
	}
	else
	{
		echo "<tr>\n";
		echo "	<td colspan=\"2\" align=\"center\"><h3><font color=\"red\"><b>Can't find \"$filever\"</b></font></h3></td>\n";
		echo "</tr>";
		echo "</table>\n";
		html_footer();
		exit;
	}

}
html_footer();

?>
